#include "se_converter.h"
#include <stdio.h>
#include <stdlib.h>
#include <linux/version.h>
#include <stdio.h>

#define VERSION_CODE(ver,rel,seq)	((ver << 16) | (rel << 8) | seq)

#define LOADMODULE      3
#define LOADNODE        2


unsigned long filelength(int f)
{
    unsigned long sz = lseek(f,0,SEEK_END);
    lseek(f,0,SEEK_SET);
    return sz;
}

int version_upgrade_check()
{
    char tmpstr[1024], tmpstr2[1024], token[256], *chk;
    char delim[] = " \t";
    FILE *f, *ft;
    int i, len;

    /* check if existing secreal2d.cf is empty or not (There is only config in DRIVERPATH when the 1st time installation) */
    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "grep -v \"#\" %s/secreal2d.cf |", DRIVERPATH);
    sprintf(tmpstr, "%s grep -v \"ttymajor\" |", tmpstr);
    sprintf(tmpstr, "%s grep -v \"calloutmajor\" > /tmp/nprtmp_checkcf", tmpstr);
    system(tmpstr);

    f = fopen ("/tmp/nprtmp_checkcf", "r");
    if (f == NULL)
    {
        printf("file open error\n");
        return(0);
    }

    if (filelength(fileno(f)))
    {
        memset(tmpstr, '\0', 1024);
        sprintf(tmpstr, "cp -f %s/config %s/secreal2d.cf", DRIVERPATH, DRIVERPATH);
        system(tmpstr);

        memset(tmpstr, '\0', 1024);
        sprintf(tmpstr, "%s/secreal2d.cf", DRIVERPATH);
        ft = fopen (tmpstr, "a+");
        if (ft == NULL)
        {
            printf("file open error_4\n");
            fclose(f);
            return -1;
        }
        for (;;)
        {
            memset(tmpstr, '\0', 1024);
            memset(tmpstr2, '\0', 1024);
            memset(token, '\0', 256);
            if (fgets(tmpstr, 1024, f) == NULL)
            {
                break;
            }
            strcpy(tmpstr2, tmpstr);
            for (i=0; i<7; i++)
            {
                if (i==0)
                {
                    strtok(tmpstr, delim);
                }
                else
                {
                    if (strtok(NULL, delim) == NULL)
                    {
                        break;
                    }
                }
            }
            // Check whether the count of parameters of configuration is more than 6.
            // That is the newer version of configuration is found. Just save them.
            if (i >= 7)
            {
                fputs (tmpstr2, ft);
            }
            // the old config format is detected. upgrading config.
            if (i == 6)
            {
                for (i=0; i<6; i++)
                {
                    if (i==0)
                    {
                        sprintf(token, "%s", strtok(tmpstr2, delim));
                        DBG_PRINT("(i=0)  token=[%s]\n", token);
                    }
                    else
                    {
                        DBG_PRINT("i=%d\n", i);
                        chk = strtok(NULL, delim);
                        if (i == 2 && chk != NULL)
                        {
                            DBG_PRINT("dataport = [%s]\n", chk);
                            sprintf(token, "%s\t%d", token, atoi(chk)+949);  // data port
                            sprintf(token, "%s\t%d", token, atoi(chk)+965);  // command port
                            continue;
                        }
                        if (chk != NULL)
                        {
                            sprintf(token, "%s\t%s", token, chk);  //  [SE-Converter IP]
                            continue;
                        }
                    }
                }
                fputs (token, ft);
            }
            else
            {
                DBG_PRINT("invalid config format.");
            }
        }
        fclose(ft);
    }
    fclose(f);
    return 0;
}

// Create new [modifle] file, copy [tmpfile] to modifle, and insert [addstr] after the continuous '#'.
// Return: 1:success 0:NG
int modify_script(char *tmpfile, char *modfile, char *addstr)
{
    char *filestr;
    FILE *f, *fos, *tf;
    int len=1024;

    filestr = (char *)malloc(1024);

    f = fopen (tmpfile, "r");
    if (f == NULL)
    {
        printf("file open error\n");
        free(filestr);
        return(0);
    }
    tf = fopen (modfile, "w");
    if (tf == NULL)
    {
        printf("file open error\n");
        free(filestr);
        return(0);
    }

    for (;;)
    {
        if (getline (&filestr, (size_t*)&len, f) < 0)
            break;
        fputs(filestr, tf);
        if (strstr(filestr, "#") != NULL)
            continue;
        else
            break;
    }

    fputs(addstr, tf);

    for (;;)
    {
        if (getline (&filestr, (size_t*)&len, f) < 0)
            break;
        fputs(filestr, tf);
        if (feof(f) == 0)
            continue;
        else
            break;
    }

    fclose(tf);
    fclose(f);
    free(filestr);
    return 1;
}

int main(int arg, char *argv[])
{
    int i, chk, len, makenode;
    int ttymajor, calloutmajor;
    int daemon_flag, cf_flag;
    char *tmpstr, *os;
    char major[20];
    FILE *f, *fos, *tf;

    if (arg > 2)
    {
        printf("\nSyntax error!!\nusage: wmloadsvr [option]\n\n");
        return -1;
    }
    else if (arg == 2)
    {
        if (strcmp(argv[1], "module") && strcmp(argv[1], "install"))
        {
            printf("\nWarning: unrecognized option -> \"%s\"\n\n", argv[1]);
        }
    }

    os = "linux";
    fos = fopen ("/etc/redhat-release", "r");
    if (fos != NULL)
    {
        fclose(fos);
        os = "linux";
    }
    else
    {
        fos = fopen ("/etc/SuSE-release", "r");
        if (fos != NULL)
        {
            fclose(fos);
            os = "SuSE";
        }
        else
        {
            fos = fopen ("/etc/debian_version", "r");
            if (fos != NULL)
            {
                fclose(fos);
                os = "debian";
            }
            else
            {
                fos = fopen ("/etc/gentoo-release", "r");
                if (fos != NULL)
                {
                    fclose(fos);
                    os = "gentoo";
                }
            }
        }
    }

    makenode = LOADNODE;
    if (arg == 2)
    {
        if (strcmp(argv[1], "module") == 0)
        {
            makenode = LOADMODULE;
        }
        else if (strcmp(argv[1], "install") == 0)
        {
            makenode = LOADMODULE;
            version_upgrade_check();
        }
    }

    tmpstr = (char *)malloc(1024);
    len = 1024;
    memset(tmpstr, '\0', 1024);
    daemon_flag = 0;
    cf_flag = 0;
    sprintf(tmpstr, "%s/secreal2d.cf", DRIVERPATH);
    f = fopen (tmpstr, "r");
    if (f == NULL)
    {
        printf("file open error\n");
        free(tmpstr);
        return(0);
    }

    /* get ttymajor & calloutmajor */
    for (;;)
    {
        if (getline (&tmpstr, (size_t*)&len, f) < 0)
        {
            break;
        }
        if (strstr(tmpstr, "#") != NULL)
        {
            continue;
        }

        memset(major, '\0', 20);
        sscanf(tmpstr, "%s", major);

        if (strstr(major, "ttymajor") != NULL)
        {
            ttymajor = atoi(strstr(major, "=")+1);
            continue;
        }

        if (strstr(major, "calloutmajor") != NULL )
        {
            calloutmajor = atoi(strstr(major, "=")+1);
            continue;
        }
    }
    fclose(f);

    /* stop daemon (secreal2d) */
    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "ps -ef | grep secreal2d |");
    sprintf(tmpstr, "%s awk '$0 !~ /grep/ {system(\"kill -15 \"$2)}'", tmpstr);
    system(tmpstr);


    DBG_PRINT("kill -15 secreal2d\n");


    if (makenode == LOADMODULE)
    {

        /* rm and mknod for all device node */
        memset(tmpstr, '\0', 1024);
        sprintf(tmpstr, "ps -ef | grep secreal2d |");
        sprintf(tmpstr, "%s awk '$0 !~ /grep/ {system(\"kill -9 \"$2)}'", tmpstr);
        system(tmpstr);
        DBG_PRINT("kill -9 secreal2d\n");

        printf("\nLoading TTY Driver...\n");
        system("rmmod secreal2 > /dev/null 2>&1");

        sprintf(tmpstr, "cd %s", DRIVERPATH);
        system(tmpstr);
        sprintf(tmpstr, "modprobe secreal2 ttymajor=%d calloutmajor=%d verbose=0", ttymajor, calloutmajor);
        system(tmpstr);
    }

//  if (makenode >= LOADNODE) {
    /* delete all device file configured in secreal2d.cf */
    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "awk '$0 !~ /#/' %s/secreal2d.cf |", DRIVERPATH);
    sprintf(tmpstr, "%s awk '$6 != \"\" ' |", tmpstr);
    sprintf(tmpstr, "%s awk '$7 != \"\" ' |", tmpstr);
    sprintf(tmpstr, "%s awk '{system(\"%s/wmrmnod \"$6); system(\"%s/wmrmnod \"$7)}'", tmpstr, DRIVERPATH, DRIVERPATH);
    system(tmpstr);

    /* create all device file configured in secreal2d.cf */
    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "awk '$0 !~ /#/' %s/secreal2d.cf |", DRIVERPATH);
    sprintf(tmpstr, "%s awk '$7 != \"\" ' |", tmpstr);
    sprintf(tmpstr, "%s awk '$8 != \"\" ' |", tmpstr);
    sprintf(tmpstr, "%s awk '{system(\"%s/wmmknod \" $7 \" %d \" $1); system(\"%s/wmmknod \" $8 \" %d \" $1)}'", tmpstr, DRIVERPATH, ttymajor, DRIVERPATH, calloutmajor);
    system(tmpstr);

    /* modify script file                         */
    /* remove string with "modprobe secreal2" and then           */
    /* append new modprobe module string with major number      */
    /* please notice not to remove the daemon starting string */
    if (os == "linux")
    {
        system("grep -v 'modprobe secreal2' /etc/rc.d/rc.local > /tmp/nprtmp_rclocal 2>&1");
        sprintf(tmpstr, "modprobe secreal2 ttymajor=%d calloutmajor=%d verbose=0\n", ttymajor, calloutmajor);
        if (modify_script("/tmp/nprtmp_rclocal", "/etc/rc.d/rc.local", tmpstr) != 1)
            return 0;
        system("rm -f /tmp/nprtmp_rclocal > /dev/null 2>&1");
        system("chmod +x /etc/rc.d/rc.local");

    }
    else if (os == "debian")
    {
        system("grep -v '#!/bin/sh' /etc/init.d/secreals > /tmp/nprtmp1 2>&1");
        system("grep -v '### BEGIN INIT INFO' /tmp/nprtmp1 > /tmp/nprtmp2 2>&1");
        system("grep -v '# Provides:' /tmp/nprtmp2 > /tmp/nprtmp3 2>&1");
        system("grep -v '# Required-Start:' /tmp/nprtmp3 > /tmp/nprtmp4 2>&1");
        system("grep -v '# Required-Stop:' /tmp/nprtmp4 > /tmp/nprtmp5 2>&1");
        system("grep -v '# Default-Start:' /tmp/nprtmp5 > /tmp/nprtmp6 2>&1");
        system("grep -v '# Default-Stop:' /tmp/nprtmp6 > /tmp/nprtmp7 2>&1");
        system("grep -v '# Description:' /tmp/nprtmp7 > /tmp/nprtmp8 2>&1");
        system("grep -v '### END INIT INFO' /tmp/nprtmp8 > /tmp/nprtmp9 2>&1");
        system("grep -v 'modprobe secreal2' /tmp/nprtmp9 > /tmp/nprtmp10 2>&1");
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
        system("grep -v 'sleep' /tmp/nprtmp10 > /tmp/nprtmp11 2>&1");
        system("grep -v 'wmloadsvr' /tmp/nprtmp11 > /tmp/nprtmp12 2>&1");
        system("cp -f /tmp/nprtmp12 /tmp/nprtmp_rclocal > /dev/null 2>&1");
#else
        system("grep -v 'wmloadsvr' /tmp/nprtmp10 > /tmp/nprtmp11 2>&1");
        system("cp -f /tmp/nprtmp11 /tmp/nprtmp_rclocal > /dev/null 2>&1");
        system("touch /tmp/nprtmp12 > /dev/null 2>&1");
#endif
        system("echo '#!/bin/sh' >> /tmp/nprtmp_rclocal");
        system("echo '### BEGIN INIT INFO' >> /tmp/nprtmp_rclocal");
        system("echo '# Provides:       secreals' >> /tmp/nprtmp_rclocal");
        system("echo '# Required-Start: $all' >> /tmp/nprtmp_rclocal");
        system("echo '# Required-Stop:' >> /tmp/nprtmp_rclocal");
        system("echo '# Default-Start:  2 3 4 5' >> /tmp/nprtmp_rclocal");
        system("echo '# Default-Stop:   0 1 6' >> /tmp/nprtmp_rclocal");
        system("echo '# Description:    Enable Real TTY service provided by Weidmueller Interface' >> /tmp/nprtmp_rclocal");
        system("echo '### END INIT INFO' >> /tmp/nprtmp_rclocal");

        sprintf(tmpstr, "modprobe secreal2 ttymajor=%d calloutmajor=%d verbose=0\n", ttymajor, calloutmajor);
        if (modify_script("/tmp/nprtmp_rclocal", "/etc/init.d/secreals", tmpstr) != 1)
            return 0;

        system("rm -f /tmp/nprtmp1 /tmp/nprtmp2 /tmp/nprtmp3 /tmp/nprtmp4 /tmp/nprtmp5 /tmp/nprtmp6 /tmp/nprtmp7 /tmp/nprtmp8 /tmp/nprtmp9 /tmp/nprtmp10 /tmp/nprtmp11 /tmp/nprtmp12 /tmp/nprtmp_rclocal");

        system("chmod +x /etc/init.d/secreals");
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
        system("update-rc.d secreals defaults");
#else
        system("update-rc.d secreals defaults 90");
#endif
    }
    else if (os == "SuSE")
    {
        /* erase the line with 'cd /usr/lib/secreal2/driver' in boot.local */
        sprintf(tmpstr, "grep -v 'cd %s' /etc/rc.d/boot.local > /tmp/nprtmp_rclocal 2>&1", DRIVERPATH);
        system(tmpstr);
        system("cp -f /tmp/nprtmp_rclocal /etc/rc.d/boot.local > /dev/null 2>&1");
        system("rm -f /tmp/nprtmp_rclocal > /dev/null 2>&1");

        /* erase the line with 'modprobe secreal2.o' in boot.local */
        system("grep -v 'modprobe secreal2' /etc/rc.d/boot.local > /tmp/nprtmp_rclocal 2>&1");
        sprintf(tmpstr, "modprobe secreal2 ttymajor=%d calloutmajor=%d verbose=0\n", ttymajor, calloutmajor);
        if (modify_script("/tmp/nprtmp_rclocal", "/etc/rc.d/boot.local", tmpstr) != 1)
            return 0;
        system("rm -f /tmp/nprtmp_rclocal > /dev/null 2>&1");
        system("chmod +x /etc/rc.d/boot.local");

    }
    else if (os == "gentoo")
    {
        /* erase the line with 'cd /usr/lib/secreal2/driver' in local.start */
        sprintf(tmpstr, "grep -v 'cd %s' /etc/conf.d/local.start > /tmp/nprtmp_rclocal 2>&1", DRIVERPATH);
        system(tmpstr);
        system("cp -f /tmp/nprtmp_rclocal /etc/conf.d/local.start > /dev/null 2>&1");
        system("rm -f /tmp/nprtmp_rclocal > /dev/null 2>&1");

        /* erase the line with 'modprobe secreal2.o' in local.start */
        system("grep -v 'modprobe secreal2' /etc/conf.d/local.start > /tmp/nprtmp_rclocal 2>&1");
        sprintf(tmpstr, "modprobe secreal2 ttymajor=%d calloutmajor=%d verbose=0\n", ttymajor, calloutmajor);
        if (modify_script("/tmp/nprtmp_rclocal", "/etc/conf.d/local.start", tmpstr) != 1)
            return 0;
        system("rm -f /tmp/nprtmp_rclocal > /dev/null 2>&1");
    }

//  }


    /* check if daemon is running or not */
    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "ps -ef | grep secreal2d | grep -v grep");
    sprintf(tmpstr, "%s > /tmp/nprtmp_checkdaemon", tmpstr);
    system(tmpstr);

    f = fopen ("/tmp/nprtmp_checkdaemon", "r");
    if (f == NULL)
    {
        DBG_PRINT("file open error_checkdaemon\n");
        free(tmpstr);
        return(0);
    }
    if (filelength(fileno(f)) != 0)
    {
        daemon_flag = 1; /* Means any secreal2d is running now. */
    }
    else
    {
        daemon_flag = 0;
    }
    fclose(f);

    /* check if secreal2d.cf is empty or not */
    sprintf(tmpstr, "%s/wmcfmat", DRIVERPATH);
    system(tmpstr);

    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "grep -v \"#\" %s/secreal2d.cf |", DRIVERPATH);
    sprintf(tmpstr, "%s grep -v \"ttymajor\" |", tmpstr);
    sprintf(tmpstr, "%s grep -v \"calloutmajor\" > /tmp/nprtmp_checkcf", tmpstr);
    system(tmpstr);

    memset(tmpstr, '\0', 1024);
    sprintf(tmpstr, "/tmp/nprtmp_checkcf");
    f = fopen (tmpstr, "r");
    if (f == NULL)
    {
        DBG_PRINT("file open error\n");
        free(tmpstr);
        return(0);
    }
    if (filelength(fileno(f)) != 0)
    {
        cf_flag = 1; /* Means configurations are exist */
    }
    else
    {
        cf_flag = 0;
    }
    fclose(f);

    memset(tmpstr, '\0', 1024);
    if (daemon_flag == 1)
    {
        // If there is secreal2d daemon running...
        if (cf_flag == 1)
        {
            // If there is secreal2d.cf configurations...
            memset(tmpstr, '\0', 1024);
            sprintf(tmpstr, "ps -ef | grep secreal2d |");
            sprintf(tmpstr, "%s awk '$0 !~ /grep/ {system(\"kill -15 \"$2)}'", tmpstr);
            system(tmpstr);
            DBG_PRINT("daemon=1, cf=1, kill -15 secreal2d\n");

        }
        else
        {
            memset(tmpstr, '\0', 1024);
            sprintf(tmpstr, "ps -ef | grep secreal2d |");
            sprintf(tmpstr, "%s awk '$0 !~ /grep/ {system(\"kill -9 \"$2)}'", tmpstr);
            system(tmpstr);
            DBG_PRINT("daemon=1, cf=0, kill -9 secreal2d\n");
        }
    }
    else
    {
        if (cf_flag == 1)
        {
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
            sleep(5);
#endif
            sprintf(tmpstr, "%s/secreal2d_redund -t 1 &", DRIVERPATH);
            system(tmpstr);
            sprintf(tmpstr, "%s/secreal2d -t 1 &", DRIVERPATH);
            system(tmpstr);
            DBG_PRINT("daemon=0, cf=1, [start daemon] %s\n", tmpstr);

        }
        else
        {
            DBG_PRINT("daemon=0, cf=0\n");
        }
    }

    memset(tmpstr, '\0', 1024);
    if (cf_flag == 0)
    {
        // If there is no configuration, remove wmloadsvr in rc.local
        if (os == "linux")
        {
            system("grep -v wmloadsvr /etc/rc.d/rc.local > /tmp/nprtmp_rclocal");
            system("cp -f /tmp/nprtmp_rclocal /etc/rc.d/rc.local > /dev/null 2>&1");
            system("rm -f /tmp/nprtmp_rclocal");
            system("chmod +x /etc/rc.d/rc.local");

        }
        else if (os == "debian")
        {
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
            system("grep -v sleep /etc/init.d/secreals > /tmp/nprtmp_rclocal");
            system("cp -f /tmp/nprtmp_rclocal /etc/init.d/secreals > /dev/null 2>&1");
            system("rm -f /tmp/nprtmp_rclocal");
#endif
            system("grep -v wmloadsvr /etc/init.d/secreals > /tmp/nprtmp_rclocal");
            system("cp -f /tmp/nprtmp_rclocal /etc/init.d/secreals > /dev/null 2>&1");
            system("rm -f /tmp/nprtmp_rclocal");
            system("chmod +x /etc/init.d/secreals");
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
            system("update-rc.d secreals defaults > /dev/null 2>&1");
#else
            system("update-rc.d secreals defaults 90 > /dev/null 2>&1");
#endif

        }
        else if (os == "SuSE")
        {
            system("grep -v wmloadsvr /etc/rc.d/boot.local > /tmp/nprtmp_rclocal");
            system("cp -f /tmp/nprtmp_rclocal /etc/rc.d/boot.local > /dev/null 2>&1");
            system("chmod +x /etc/rc.d/boot.local");
            system("rm -f /tmp/nprtmp_rclocal");
        }
        else if (os == "gentoo")
        {
            system("grep -v wmloadsvr /etc/conf.d/local.start > /tmp/nprtmp_rclocal");
            system("cp -f /tmp/nprtmp_rclocal /etc/conf.d/local.start > /dev/null 2>&1");
            system("rm -f /tmp/nprtmp_rclocal");
        }
    }
    else if (cf_flag == 1)
    {
        // If there is no wmloadsvr in rc.local, add it...
        if (os == "linux")
        {
            system("grep wmloadsvr /etc/rc.d/rc.local > /tmp/nprtmp_chkstr");
            sprintf(tmpstr, "/tmp/nprtmp_chkstr");
            f = fopen (tmpstr, "r");
            if (f == NULL)
            {
                DBG_PRINT("file open error(str)\n");
                free(tmpstr);
                return(0);
            }
            if (filelength(fileno(f)) == 0)
            {
                sprintf(tmpstr, "echo '%s/wmloadsvr' >> /etc/rc.d/rc.local", DRIVERPATH);
                system(tmpstr);
                system("chmod +x /etc/rc.d/rc.local");
            }
            fclose(f);

        }
        else if (os == "debian")
        {
            system("grep wmloadsvr /etc/init.d/secreals > /tmp/nprtmp_chkstr");
            sprintf(tmpstr, "/tmp/nprtmp_chkstr");
            f = fopen (tmpstr, "r");
            if (f == NULL)
            {
                DBG_PRINT("file open error(str)\n");
                free(tmpstr);
                return(0);
            }
            if (filelength(fileno(f)) == 0)
            {
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
                sprintf(tmpstr, "echo 'sleep 10' >> /etc/init.d/secreals", DRIVERPATH);
                system(tmpstr);
#endif
                sprintf(tmpstr, "echo '%s/wmloadsvr' >> /etc/init.d/secreals", DRIVERPATH);
                system(tmpstr);
                system("chmod +x /etc/init.d/secreals");
            }
            fclose(f);
#if (LINUX_VERSION_CODE == VERSION_CODE(2,6,28))
            system("update-rc.d secreals defaults > /dev/null 2>&1");
#else
            system("update-rc.d secreals defaults 90 > /dev/null 2>&1");
#endif

        }
        else if (os == "SuSE")
        {
            system("grep wmloadsvr /etc/rc.d/boot.local > /tmp/nprtmp_chkstr");
            sprintf(tmpstr, "/tmp/nprtmp_chkstr");
            f = fopen (tmpstr, "r");
            if (f == NULL)
            {
                DBG_PRINT("file open error(str)\n");
                free(tmpstr);
                return(0);
            }
            if (filelength(fileno(f)) == 0)
            {
                sprintf(tmpstr, "echo '%s/wmloadsvr' >> /etc/rc.d/boot.local", DRIVERPATH);
                system(tmpstr);
                system("chmod +x /etc/rc.d/boot.local");
            }
            fclose(f);
        }
        else if (os == "gentoo")
        {
            system("grep wmloadsvr /etc/conf.d/local.start > /tmp/nprtmp_chkstr");
            sprintf(tmpstr, "/tmp/nprtmp_chkstr");
            f = fopen (tmpstr, "r");
            if (f == NULL)
            {
                DBG_PRINT("file open error(str)\n");
                free(tmpstr);
                return(0);
            }
            if (filelength(fileno(f)) == 0)
            {
                sprintf(tmpstr, "echo '%s/wmloadsvr' >> /etc/conf.d/local.start", DRIVERPATH);
                system(tmpstr);
            }
            fclose(f);
        }
    }

    system("rm -f /tmp/nprtmp_checkdaemon");
    //system("rm -f /tmp/nprtmp_checkcf");
    system("rm -f /tmp/nprtmp_chkstr");

    printf("Complete.\n\n");
    free(tmpstr);
    return 0;
}
