#!/bin/sh

set -x

# shellcheck disable=SC1091
. /usr/lib/uc-fw-utils/functions

# Version 0.1

# Ip address of the TAP device
# This IP address needs to be entered as 'Default Gateway' in the CODESYS IDE.
# IMPORTANT: The chosen Ip address for TAP device needs to be in a different subnet as the IP address of the EtherCat Master.
# E.g. : TAP_IP_ADDRESS=192.168.2.1/24
TAP_IP_ADDRESS=<IP_ADDRESS>/<NETMASK>

# The engineering interface is the network interface that is connected to the engineering device.
# This variable is not required for the GW30 variants.
# E.g. : ENGINEERING_NETWORK_INTERFACE=eth0
ENGINEERING_NETWORK_INTERFACE=<NETWORK_INTERFACE>

setupTap(){
    echo "Creating tap0 device"
    ip tuntap add dev tap0 mode tap
    ip addr add $TAP_IP_ADDRESS dev tap0
    ip link set dev tap0 up
}

setupIpTables(){
    productName=$(firmware_get_variable product_name | tr '[:lower:]' '[:upper:]') 
    if [ "$productName" = "IOT-GW30" ] || [ "$productName" = "IOT-GW30-4G-EU" ]; then
        echo "GW30 variant detected. No iptables configuration required."
    fi
    echo "Setting IP tables"
    iptables -A FORWARD -i $ENGINEERING_NETWORK_INTERFACE -o tap0 -j ACCEPT
    iptables -A FORWARD -i tap0 -o $ENGINEERING_NETWORK_INTERFACE -j ACCEPT
}

setupTap
setupIpTables 