#!/bin/sh

SCRIPTPATH="$( cd "$(dirname "$0")" ; pwd -P )"

echo "Start procon-web-iot service installer..."
echo "[Unit]
Description=PROCON-WEB HMI runtime system
Documentation=https://www.gti.de/produkte-der-gti/procon-web/
After=network.target systemd-modules-load.service

[Service]
WorkingDirectory=$SCRIPTPATH
Environment=\"HOME=$SCRIPTPATH\" \"PATH=$SCRIPTPATH\"
ExecStart=$SCRIPTPATH/procon-web-iot


StandardOutput=journal
StandardError=journal

[Install]
WantedBy=multi-user.target" >> procon-web-iot.service

mv ./procon-web-iot.service /lib/systemd/system/
systemctl enable procon-web-iot.service
systemctl start procon-web-iot.service
