'use strict';var commonjsGlobal="undefined"!==typeof globalThis?globalThis:"undefined"!==typeof window?window:"undefined"!==typeof global?global:"undefined"!==typeof self?self:{};function unwrapExports(h){return h&&h.__esModule&&Object.prototype.hasOwnProperty.call(h,"default")?h["default"]:h}function createCommonjsModule(h,f){return f={exports:{}},h(f,f.exports),f.exports}
var Webserver_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.Webserver=void 0;const g=require("body-parser"),d=require("cors"),c=require("express"),a=require("fs-extra"),b=require("helmet"),e=require("http"),k=require("http-status-codes"),l=require("https"),m=require("os"),q=require("path"),w=require("ws"),x=require("url"),p=require("stoppable"),u=require("util"),r=require("@gti/basic-fnc"),v=require("@gti/service-base"),t=require("@gti/globals");class n{constructor(b,
a,e,k,d,l,m,f,g,q){this.logger=b;this.config=a;this.sessionHandling=e;this.tagHandling=k;this.userManagementHandling=d;this.scriptHandling=l;this.dataLoggerHandling=m;this.dataManagementHandling=f;this.notificationHandling=g;this.gridHandling=q;this.openWebsocketConnections=new Set;this.licenseData=new r.LicenseData;this.basicFnc=new r.BasicFnc;this.app=c()}get currentSessions(){return this.sessionHandling&&this.sessionHandling.sessions?Array.from(this.sessionHandling.sessions.values()):[]}get httpEnable(){return this.config.http.enable}get httpsEnable(){return this.config.https.enable}get httpPort(){return this.config.http.port}get httpsPort(){return this.config.https.port}get certificateFile(){return this.config.https.certificateFile}get keyFile(){return this.config.https.keyFile}get running(){return this._running}async start(a,
e,k){this.licenseData=k;this.runningProjectDirectory=a;this.runningProjectExportId=void 0!==e?e:null;this.app=c();this.app.use(d());this.app.use(b());this.app.use(g.json());this.app.use(g.urlencoded({extended:!0,limit:"10mb",parameterLimit:1E4}));await this.createHttpServer();await this.createHttpsServer();this.systemStateConfig=(await t.ConfigurationHelper.getServiceConfiguration("system")).systemState;a=a?q.join(a,n.WEB_VISU_DIR):void 0;await this.initHttpHandler(a,k,this.runningProjectExportId);
this._running=!0}async stop(){for(const b of this.openWebsocketConnections)b.close();this.openWebsocketConnections.clear();this.httpServer&&(this.httpServer.setTimeout(1),await u.promisify(this.httpServer.stop.bind(this.httpServer))(),this.logger.info("stopped http server"));this.httpsServer&&(this.httpsServer.setTimeout(1),await u.promisify(this.httpsServer.stop.bind(this.httpsServer))(),this.logger.info("stopped https server"));this.sessionHandling.sessions.clear();this._running=!1}async createHttpServer(){if(this.httpEnable)try{this.httpServer=
p(e.createServer(this.app),n.FORCE_SERVER_CLOSE_TIME),await this.startServer(this.httpServer,this.httpPort),await this.initWebsocketServer(this.httpServer),this.logger.info(`started http server at port: ${this.httpPort}`)}catch(y){throw this.logger.error("Couldn't start http server"),y;}}async createHttpsServer(){if(this.httpsEnable){var b=this.httpsServer;if(this.keyFile)if(this.certificateFile)if(a.existsSync(this.certificateFile))if(a.existsSync(this.keyFile))try{const b=await a.readFile(this.certificateFile),
e=await a.readFile(this.keyFile);this.httpsServer=p(l.createServer({cert:b,key:e},this.app),n.FORCE_SERVER_CLOSE_TIME);await this.startServer(this.httpsServer,this.httpsPort);await this.initWebsocketServer(this.httpsServer);this.logger.info(`started https server at port: ${this.httpsPort}`)}catch(z){throw this.logger.error("Couldn't start https server"),z;}else b||this.logger.error(`Couldn't find key file specified in configuration: ${this.keyFile}. Won't start https server`);else b||this.logger.error(`Couldn't find certificate file specified in configuration: ${this.certificateFile}. Won't start https server`);
else b||this.logger.error("https is enabled in configuration but there is no certificate file specified. Won't start https server");else b||this.logger.error("https is enabled in configuration but there is no key file specified. Won't start https server")}}startServer(b,a){return new Promise((e,c)=>{b.on("error",(b)=>c(b));b.listen(a,()=>e())})}async initWebsocketServer(b){(new w.Server({server:b})).on("connection",this.onWebsocketConnected.bind(this))}onWebsocketConnected(b,a){a=x.parse(a.url,!0).query.sessionId;
const e=this.sessionHandling.sessions.get(a);e?(this.openWebsocketConnections.add(b),this.sessionHandling.updateLasRequestTime(e),e.initWebsocketConnection(b),b.on("message",(b)=>this.onWebsocketMessage(e,b)),b.on("error",async(a)=>await this.onWebsocketClosed(e,b)),b.on("close",async()=>await this.onWebsocketClosed(e,b))):(b.send(JSON.stringify({error:`Invalid session id: ${a}`})),b.close())}async onWebsocketClosed(b,a){await this.sessionHandling.closeSession(b);this.openWebsocketConnections.delete(a)}onWebsocketMessage(b,
a){"1"===a&&this.sessionHandling.updateLasRequestTime(b)}async initHttpHandler(b,a,e){await this.isProjectValid()?await this.isLicenseValid()?(this.app.use("/computerId",this.onGetComputerId.bind(this)),this.app.use("/Heartbeat",(b,a)=>a.send({d:null})),this.app.use("/systemstate",(b,a)=>this.redirectToSystemState(b,a,"")),this.app.use(c.static(b,{index:n.WEB_VISU_ENTRY_FILE_NAME})),this.sessionHandling.initHandlers(this.app,a,e),this.app.use(this.checkSession.bind(this)),this.tagHandling.initHandlers(this.app),
this.scriptHandling&&this.scriptHandling.initHandlers(this.app),this.userManagementHandling&&this.userManagementHandling.initHandlers(this.app),this.dataLoggerHandling&&this.dataLoggerHandling.initHandlers(this.app),this.dataManagementHandling&&this.dataManagementHandling.initHandlers(this.app),this.notificationHandling&&this.notificationHandling.initHandlers(this.app),this.gridHandling&&this.gridHandling.initHandlers(this.app)):this.app.use("/",(b,a)=>this.redirectToSystemState(b,a,"license")):this.app.use("/",
(b,a)=>this.redirectToSystemState(b,a,"projects"))}async onGetComputerId(b,a){b=await this.getComputerIDFile();a.setHeader("Content-Length",b.length);a.setHeader("Content-Type","application/octet-stream");a.setHeader("Content-Disposition",`attachment; filename=ComputerID_${m.hostname}.cid`);a.write(b,"binary");a.end()}redirectToSystemState(b,a,e){const [c,k]=this.getSystemStateData(b.protocol);a.redirect(`${c}://${b.hostname}:${k}/${e}`)}getSystemStateData(b){b=[b,"http"===b?"https":"http"];for(const a of b)if(this.systemStateConfig[a].enable)return[a,
this.systemStateConfig[a].port];return["http",this.systemStateConfig.http.port]}async checkSession(b,a,e){var c;b=null!==(c=b.headers.sessionid)&&void 0!==c?c:b.query.sessionId;(c=this.sessionHandling.sessions.get(b))?(a.locals.session=c,e()):(this.logger.verbose(`client sent request with invalid session id ${b}`),a.status(k.UNAUTHORIZED).send("Invalid Session!"))}async getComputerIDFile(){return`${await this.basicFnc.getComputerID()}\r\n${m.hostname()}\r\nComputerID Version 3 IoT\r\n`}async isLicenseValid(){if(this.licenseData.state===
r.LicenseState.FAILED||this.licenseData.state===r.LicenseState.EXPIRED)return!1;const [b,a]=await this.getNeededDriverAndTagCount();return b>this.licenseData.tagCount||a>this.licenseData.driverCount?!1:!0}async isProjectValid(){return this.runningProjectDirectory?await v.VersionHelper.isProjectVersionValid(this.runningProjectDirectory)&&await v.VersionHelper.isRuntimeVersionValid(this.runningProjectDirectory):!1}async getNeededDriverAndTagCount(){var b=q.join(this.runningProjectDirectory,"Tags.json");
b=await a.readJSON(b,{throws:!1});var e=new t.TagDefinitionJSONCreator(b);b=e.tagDefinitions.length;e=(new Set(e.tagDefinitions.map((b)=>b.driver.id).filter((b)=>b!==t.Drivers.getDriverId("Merker")))).size;return[b,e]}}f.Webserver=n;n.WEB_VISU_ENTRY_FILE_NAME="index.htm";n.WEB_VISU_ENTRY_FILE_DEMO_NAME="index_Demo.htm";n.WEB_VISU_DIR="WebVisu";n.FORCE_SERVER_CLOSE_TIME=300});unwrapExports(Webserver_1);
var Webserver_2=Webserver_1.Webserver,WebserverBuilder_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.WebserverBuilder=void 0;class g{constructor(d,c,a,b){this.logger=d;this.config=c;this.sessionHandling=a;this.tagHandling=b}withUserManagement(d){this.userManagementHandling=d;return this}withDataLogger(d){this.dataLoggerHandling=d;return this}withDataManagement(d){this.dataManagementHandling=d;return this}withScripting(d){this.scriptHandling=d;return this}withNotification(d){this.notificationHandling=
d;return this}withGrid(d){this.gridHandling=d;return this}build(){return new Webserver_1.Webserver(this.logger,this.config,this.sessionHandling,this.tagHandling,this.userManagementHandling,this.scriptHandling,this.dataLoggerHandling,this.dataManagementHandling,this.notificationHandling,this.gridHandling)}}f.WebserverBuilder=g});unwrapExports(WebserverBuilder_1);
var WebserverBuilder_2=WebserverBuilder_1.WebserverBuilder,DataLoggerTrendExporter_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.DataLoggerTrendExporter=void 0;const g=require("@gti/globals");class d{static async export(c,a){const b=this.extractTagIds(c);this.fillDataGaps(c,b);a=this.buildExportHeader(b,a);c=Array.from(c).map((a)=>d.buildExportLine(b,a[0],a[1])).join("\r\n");return`${a}\r\n${c}`}static fillDataGaps(c,a){const b=new Map;for(const [,e]of c)for(const c of a)e.has(c)||
e.set(c,b.get(c)),b.set(c,e.get(c))}static extractTagIds(c){const a=new Set;for(const b of c.values())for(const e of b.keys())a.add(e);return Array.from(a).sort()}static buildExportHeader(c,a){return`Time;${c.map((b)=>[d.findTagDefinitionByTagId(b,a),b]).map(([b,a])=>d.buildTagString(b,a)).join(";")}`}static buildExportLine(c,a,b){a=`${(new Date(a)).toISOString()}`;c=c.map((a)=>{var e;return null!==(e=b.get(a))&&void 0!==e?e:""}).join(";");return`${a};${c}`}static findTagDefinitionByTagId(c,a){return a.find((b)=>
g.TagHelper.genericHtmlId(b)===g.TagHelper.getGenericHtmlIdOfHtmlId(c))}static buildTagString(c,a){return c?1<c.fieldSize?`${c.name}[${g.TagHelper.extractFieldIndexOfHtmlId(a)}]`:c.name:a}}f.DataLoggerTrendExporter=d});unwrapExports(DataLoggerTrendExporter_1);
var DataLoggerTrendExporter_2=DataLoggerTrendExporter_1.DataLoggerTrendExporter,DataLoggerHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.DataLoggerHandling=void 0;const g=require("@gti/globals"),d=require("@gti/service-base"),c=require("http-status-codes");class a{constructor(b,a,c){this.logger=b;this.tagStoreConnClient=c;this.exportCache=new Map;this.dataLoggerPointConnection=new d.DataLoggerPointFeathersConnection(b,a);this.tagDefinitionConnection=
new d.TagDefinitionFeathersConnection(c)}initHandlers(b){b.post("/GetLoggerValues",this.onGetProfile.bind(this));b.post("/GetChargesByTime",this.onGetCharges.bind(this));b.post("/ExportLoggerData",this.OnExportLoggerData.bind(this));b.get("/DownloadLoggerData",this.onDownloadTrendExport.bind(this))}async OnExportLoggerData(b,e){const c=e.locals.session,d=b.body.filename;b=await this.dataLoggerPointConnection.getGroupedTrendExportData({tagIds:b.body.traceTagIds,from:new Date(b.body.from),to:new Date(b.body.to)});
const m=await this.tagDefinitionConnection.getTagDefinitions();b=await DataLoggerTrendExporter_1.DataLoggerTrendExporter.export(b,m);this.exportCache.has(c.sessionId)||this.exportCache.set(c.sessionId,new Map);this.exportCache.get(c.sessionId).set(d,b);setTimeout(()=>this.removeExportCacheEntry(c.sessionId,d),a.CACHE_RESET_TIME_MS);e.send({d}).end()}async onDownloadTrendExport(b,a){var e;const d=a.locals.session;b=b.query.filename;const m=null===(e=this.exportCache.get(d.sessionId))||void 0===e?void 0:
e.get(b);m?(this.removeExportCacheEntry(d.sessionId,b),a.setHeader("Content-Disposition",`attachment; filename=${b}.csv`),a.send(m)):a.sendStatus(c.BAD_REQUEST)}async onGetProfile(b,a){try{const e=Object.assign({},b.body,{from:new Date(b.body.from),to:new Date(b.body.to)}),c=(await this.dataLoggerPointConnection.readPoints(e)).map((b)=>({Value:b.value,ValueTime:g.Util.toFrontendDate(b.logTime)}));a.send({d:c})}catch(k){a.sendStatus(c.INTERNAL_SERVER_ERROR)}}async onGetCharges(b,a){try{const e=Object.assign({},
b.body,{from:new Date(b.body.from),to:new Date(b.body.to)}),c=(await this.dataLoggerPointConnection.readPoints(e)).map((a,e,c)=>({End:g.Util.toFrontendDate(e<c.length-1?c[e+1].logTime:b.body.to),Id:b.body.tagId,Name:a.value,Start:g.Util.toFrontendDate(a.logTime)}));a.send({d:c})}catch(k){a.sendStatus(c.INTERNAL_SERVER_ERROR)}}removeExportCacheEntry(b,a){var e,c;(null===(e=this.exportCache.get(b))||void 0===e?0:e.has(a))&&this.exportCache.get(b).delete(a);0===(null===(c=this.exportCache.get(b))||void 0===
c?void 0:c.size)&&this.exportCache.delete(b)}}f.DataLoggerHandling=a;a.CACHE_RESET_TIME_MS=1E3});unwrapExports(DataLoggerHandling_1);
var DataLoggerHandling_2=DataLoggerHandling_1.DataLoggerHandling,GridFilter_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.GridFilter=void 0;class g{constructor(d,c){this.logger=d;this.valueSupplier=c}filter(d,c,a){return c.every((b)=>this.handleFilter(b,d,a))}handleFilter(d,c,a){return d.SubFilters?this.filterBySubFilter(c,d.SubFilters,a):this.doFilter(c,d,a)}filterBySubFilter(d,c,a){const [b,e]=this.createFilterFuncs(d,c,a);if(0<b.length){d=b[0]();if(0<e.length)for(c=
0;c<e.length;c++)d=e[c](d,b[c+1]);return d}return!0}createFilterFuncs(d,c,a){const b=[],e=[];for(const [k,l]of c.entries())b.push(()=>this.doFilter(d,l,a)),l.SubFilters&&(b.push(()=>this.filterBySubFilter(d,l.SubFilters,a)),e.push("OR"===l.SubFilterConnector?g.OR:g.AND)),k<c.length-1&&e.push("OR"===c[k+1].FilterConnector?g.OR:g.AND);return[b,e]}doFilter(d,c,a){const b=g.FILTER_OPERATORS.get(c.FilterType);d=this.valueSupplier(c.ColumnName,d,a);return void 0!==d?b(d,c.FilterValue,c.SecondFilterValue):
!0}}f.GridFilter=g;g.FILTER_OPERATORS=new Map([["Equal",(d,c)=>d==c],["NotEqual",(d,c)=>d!=c],["Smaller",(d,c)=>d<c],["Bigger",(d,c)=>d>c],["SmallerEqual",(d,c)=>d<=c],["BiggerEqual",(d,c)=>d>=c],["Null",(d)=>void 0===d],["NotNull",(d)=>void 0!==d],["Like",(d,c)=>0<=(d+"").indexOf(c+"")],["NotLike",(d,c)=>0>(d+"").indexOf(c+"")],["StartsWith",(d,c)=>(d+"").startsWith(c+"")],["StartsNotWith",(d,c)=>!(d+"").startsWith(c+"")],["EndsWith",(d,c)=>0===(d+"").indexOf(c+"",(d+"").length-(c+"").length)],["EndsNotWith",
(d,c)=>0!==(d+"").indexOf(c+"",(d+"").length-(c+"").length)],["Between",(d,c,a)=>d>=c&&d<=a]]);g.OR=(d,c)=>d||c();g.AND=(d,c)=>d&&c()});unwrapExports(GridFilter_1);
var GridFilter_2=GridFilter_1.GridFilter,GridNotificationValueHelper_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.GridNotificationValueHelper=f.DateConvertType=void 0;const g=require("@gti/globals");var d;(function(a){a[a.ISO=0]="ISO";a[a.Designer=1]="Designer";a[a.Timestamp=2]="Timestamp"})(d=f.DateConvertType||(f.DateConvertType={}));class c{static getNotificationValueFromColumnName(a,b,e,d){return(a=c.NOTIFICATION_COLUMN_VALUE_SUPPLIERS.get(a))?a(b,e,
d):void 0}static toCorrectLanguageText(a,b){return a.definition.messageText.get(b)||a.definition.messageText.get("default")||null}static convertDate(a,b){switch(b){case d.Designer:return g.Util.toFrontendDate(a);case d.ISO:return null===a||void 0===a?void 0:a.toISOString();case d.Timestamp:return null===a||void 0===a?void 0:a.getTime()}}static getGroupName(a,b){return b.definition.groups&&Array.isArray(b.definition.groups)?b.definition.groups[a]:""}}f.GridNotificationValueHelper=c;c.MESSAGE_TYPES=
new Map([[g.MessageType.Alert,"A"],[g.MessageType.Availabilty,"V"],[g.MessageType.Info,"I"],[g.MessageType.Logging,"L"],[g.MessageType.MachineTime,"Z"],[g.MessageType.Message,"M"],[g.MessageType.State,"S"],[g.MessageType.Times,"T"],[g.MessageType.Warning,"W"]]);c.NOTIFICATION_COLUMN_VALUE_SUPPLIERS=new Map([["Type",(a)=>c.MESSAGE_TYPES.get(a.definition.messageType)],["Number",(a)=>{var b;return null!==(b=a.definition.number)&&void 0!==b?b:null}],["RegTime",(a,b)=>c.convertDate(a.creationTime,b)],
["AckTime",(a,b)=>c.convertDate(a.acknowledgeTime,b)],["EndTime",(a,b)=>c.convertDate(a.goneTime,b)],["Text",(a,b,e)=>c.toCorrectLanguageText(a,e)],["Comment",(a)=>a.comment],["Instance",(a)=>{var b;return null!==(b=a.id)&&void 0!==b?b:null}],["Group1",(a)=>c.getGroupName(0,a)],["Group2",(a)=>c.getGroupName(1,a)],["Group3",(a)=>c.getGroupName(2,a)],["Group4",(a)=>c.getGroupName(3,a)]])});unwrapExports(GridNotificationValueHelper_1);
var GridNotificationValueHelper_2=GridNotificationValueHelper_1.GridNotificationValueHelper,GridNotificationValueHelper_3=GridNotificationValueHelper_1.DateConvertType,NotificationHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.NotificationHandling=void 0;const g=require("@gti/globals"),d=require("@gti/service-base");class c{constructor(a,b,e){this.logger=a;this.notificationConnClient=b;this.sessionHandling=e;this.notificationConnection=new d.NotificationFeathersConnection(this.logger,
this.notificationConnClient);this.notificationConnection.onActiveNotificationsUpdated(this.onActiveNotificationsUpdated.bind(this));this.notificationFilterHandling=new GridFilter_1.GridFilter(a,(b,a,e)=>GridNotificationValueHelper_1.GridNotificationValueHelper.getNotificationValueFromColumnName(b,a,GridNotificationValueHelper_1.DateConvertType.Timestamp,e.dataStore.get(c.LANGUAGE_KEY)))}initHandlers(a){a.post("/SetLanguage",this.onSetLanguage.bind(this));a.post("/MessageBoxCreated",this.onMessageBoxCreated.bind(this));
a.post("/MessageBoxClosed",this.onMessageBoxClosed.bind(this));a.post("/AcknowledgeMessages",this.onAcknowledgeMessages.bind(this));a.post("/ResetMessages",this.onResetMessages.bind(this));a.post("/CommentMessages",this.onCommentMessages.bind(this))}async onSetLanguage(a,b){const e=b.locals.session;e.dataStore.set(c.LANGUAGE_KEY,a.body.id);a=await this.notificationConnection.getActiveNotifications();this.sendActiveNotificationsToClient(e,a);b.send({d:null})}async onMessageBoxCreated(a,b){a=b.locals.session;
const e=await this.notificationConnection.getActiveNotifications();this.sendActiveNotificationsToClient(a,e);b.send({d:null})}async onMessageBoxClosed(a,b){b.locals.session.dataStore.set(c.MSG_BOX_CLOSED_KEY,new Date);b.send({d:null})}async onAcknowledgeMessages(a,b){var e;0<(null===(e=a.body.keys)||void 0===e?void 0:e.length)&&Array.isArray(a.body.keys)?(a=a.body.keys.map((b)=>({instanceId:b.Instance,notificationNumber:b.Number})),await this.notificationConnection.acknowledgeNotifications(a)):"box"===
a.body.requestControlId?await this.acknowledgeMultipleMessagesFromBox(b.locals.session):(await this.acknowledgeMultipleMessages(a.body.requestControlId,b.locals.session,c.ALERT_PROTOCOLS_KEY,()=>this.notificationConnection.getAllNotifications()),await this.acknowledgeMultipleMessages(a.body.requestControlId,b.locals.session,c.ALERT_LISTS_KEY,()=>this.notificationConnection.getAllCurrentNotifications()));b.send({d:null})}async acknowledgeMultipleMessages(a,b,e,c){var d,k;const f=null===(d=b.dataStore.get(e))||
void 0===d?void 0:d.get(a);f&&(a=(null!==(k=await c())&&void 0!==k?k:[]).filter((a)=>this.notificationFilterHandling.filter(a,f.filter,b)).map((b)=>({instanceId:b.id,notificationNumber:b.definition.number})),await this.notificationConnection.acknowledgeNotifications(a))}async acknowledgeMultipleMessagesFromBox(a){const b=await this.notificationConnection.getActiveNotifications();a=this.filterActiveNotifications(a,b).map((b)=>({instanceId:b.id,notificationNumber:b.definition.number}));await this.notificationConnection.acknowledgeNotifications(a)}async onResetMessages(a,
b){var e;if(0<(null===(e=a.body.keys)||void 0===e?void 0:e.length))for(const b of a.body.keys)await this.notificationConnection.updateNotification({id:b.Instance,gone:!0,definition:{number:b.Number}});else await this.notificationConnection.updateNotification({id:null,gone:!0});b.send({d:null})}async onCommentMessages(a,b){if(a.body.keys)for(const b of a.body.keys)await this.notificationConnection.updateNotification({id:b.Instance,comment:a.body.comment,definition:{number:b.Number}});else await this.notificationConnection.updateNotification({id:null,
comment:a.body.comment});b.send({d:null})}onActiveNotificationsUpdated(a){if(a)for(const b of this.sessionHandling.sessions.values())this.sendActiveNotificationsToClient(b,a)}sendActiveNotificationsToClient(a,b){b=this.filterActiveNotifications(a,b);a.sendMessageToClient(this.createActiveNotificationsChangedMessage(a,b[0],b.length))}filterActiveNotifications(a,b){const e=a.dataStore.get(c.MSG_BOX_CLOSED_KEY);b=b.filter((b)=>!1!==b.definition.messageBox);return e?b.filter((b)=>b.creationTime>e):b}createActiveNotificationsChangedMessage(a,
b,e){const d={type:"pushMessageBox"};b&&(a=a.dataStore.get(c.LANGUAGE_KEY),a=b.definition.messageText.get(a)||b.definition.messageText.get("default"),d.options={instance:b.id,number:b.definition.number,text:a,time:g.Util.toFrontendDate(b.creationTime),totalCount:e,type:b.definition.messageType});return d}}f.NotificationHandling=c;c.MSG_BOX_CLOSED_KEY="messageBoxClosed";c.LANGUAGE_KEY="language";c.ALERT_LISTS_KEY="AlertList";c.ALERT_PROTOCOLS_KEY="AlertProtocol"});unwrapExports(NotificationHandling_1);
var NotificationHandling_2=NotificationHandling_1.NotificationHandling,ScriptingHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.ScriptingHandling=void 0;const g=require("@gti/service-base"),d=require("http-status-codes");class c{constructor(a,b,e){this.logger=a;this.scriptConnClient=b;this.sessionHandling=e;this.scriptConnection=new g.ScriptExecutionFeathersConnection(this.scriptConnClient);this.scriptConnection.onChangePicture(this.onChangePicture.bind(this))}initHandlers(a){a.post("/ExecuteScript",
(b,a)=>this.onExecuteScriptOrFunction(b,a,c.buildScriptExecutionRequest));a.post("/ExecuteScriptFunction",(b,a)=>this.onExecuteScriptOrFunction(b,a,c.buildFunctionExecutionRequest));a.post("/StartScript",(b,a)=>this.onStartStopScript(b,a,(b)=>this.scriptConnection.startScript(b)));a.post("/StopScript",(b,a)=>this.onStartStopScript(b,a,(b)=>this.scriptConnection.stopScript(b)))}async onStartStopScript(a,b,e){const c=b.locals.session;void 0===this.scriptConnection?(this.logger.error("There is no connection to scripter"),
b.sendStatus(d.INTERNAL_SERVER_ERROR)):(a=Object.assign({sessionId:c.sessionId},a.body),await e(a),b.send({d:null}))}async onExecuteScriptOrFunction(a,b,e){const c=b.locals.session;if(void 0===this.scriptConnection)this.logger.error("There is no connection to scripter"),b.sendStatus(d.INTERNAL_SERVER_ERROR);else try{await this.scriptConnection.executeScriptOrFunction(e(a,c)),b.send({d:null})}catch(l){b.sendStatus(d.INTERNAL_SERVER_ERROR)}}onChangePicture(a){a={options:{name:a},type:"changePicture"};
for(const b of this.sessionHandling.sessions.values())b.sendMessageToClient(a)}static buildScriptExecutionRequest(a,b){return{clientSessionId:b.sessionId,scriptName:a.body.scriptName}}static buildFunctionExecutionRequest(a,b){const e=a.body.functionName.split(".")[0],c=a.body.functionName.split(".")[1];return{clientSessionId:b.sessionId,functionName:c,params:a.body.paramArray,scriptName:e}}}f.ScriptingHandling=c});unwrapExports(ScriptingHandling_1);
var ScriptingHandling_2=ScriptingHandling_1.ScriptingHandling,Session_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.Session=void 0;const g=require("os");class d{constructor(c,a,b){this.logger=c;this.sessionId=a;this.ip=b;this.hostname=g.hostname();this.registeredTags=new Set;this.dataStore=new Map;this.bufferedSocketMessages=[]}initWebsocketConnection(c){this.websocketConnection=c;for(const a of this.bufferedSocketMessages)this.sendMessageToClient(a);this.bufferedSocketMessages=
[]}hasWebsocketConnection(){return void 0!==this.websocketConnection}sendMessageToClient(c){if(void 0===this.websocketConnection)this.bufferedSocketMessages.push(c);else try{this.websocketConnection.send(JSON.stringify(c))}catch(a){this.logger.verbose("Couldn't send message to client")}}stopConnection(){try{this.websocketConnection.close()}catch(c){}}}f.Session=d});unwrapExports(Session_1);
var Session_2=Session_1.Session,SessionHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.SessionHandling=void 0;const g=require("@gti/service-base"),d=require("moment");class c{constructor(a,b,e){this.logger=a;this.tagConnClient=b;this.connectionTimeout=e;this.sessions=new Map;this.projectExportId=null;this.tagConnection=new g.TagFeathersConnection(this.logger,this.tagConnClient,"tag-store","tag-store");setInterval(()=>this.checkSession(),c.CHECK_SESSION_ALIVE_TIME)}setScriptConnectionClient(a){this.scriptConnection=
new g.ScriptExecutionFeathersConnection(a)}initHandlers(a,b,e){a.post("/OpenSession",this.onOpenSession.bind(this));a.post("/CloseSession",this.onCloseSession.bind(this));this.licenseData=b;this.projectExportId=e}async onOpenSession(a,b){this.logger.verbose("OpenSession received");if(this.licenseData.clientCount<=this.sessions.size)b.send({d:JSON.stringify({teachInRequired:!0,teachState:1})});else{a=a.ip;var e=a.match(/(\d+\.){3}\d+/);e&&e[0]&&(a=e[0]);e=await this.tagConnection.createSession();a=
new Session_1.Session(this.logger,e,a);this.sessions.set(a.sessionId,a);b.send({d:JSON.stringify({serverWebSocketPort:b.connection.localPort,hasWebSocket:!0,sessionId:a.sessionId,configId:this.projectExportId})})}}async onCloseSession(a,b){(a=this.sessions.get(a.headers.sessionid))&&await this.closeSession(a);b.end()}async closeSession(a){this.sessions.delete(a.sessionId);await this.tagConnection.deleteSession(a.sessionId);this.scriptConnection&&await this.scriptConnection.stopScript({sessionId:a.sessionId});
a.stopConnection()}updateLasRequestTime(a){a&&(a.lastRequest=d())}checkSession(){for(const a of this.sessions.values())d().diff(a.lastRequest)>this.connectionTimeout&&this.closeSession(a)}}f.SessionHandling=c;c.CHECK_SESSION_ALIVE_TIME=5E3});unwrapExports(SessionHandling_1);
var SessionHandling_2=SessionHandling_1.SessionHandling,TagHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.TagHandling=void 0;const g=require("@gti/globals"),d=require("@gti/service-base"),c=require("http-status-codes");class a{constructor(b,a,c,l){this.logger=b;this.tagConnClient=a;this.sessionHandling=c;this.immediateWriteTagResponse=l;this.tagConnection=new d.TagFeathersConnection(this.logger,this.tagConnClient,"tag-store","tag-store");this.tagConnection.onTagsWritten((b)=>
this.onTagStoreUpdatedTags(b))}initHandlers(b){b.post("/RegisterTags",this.onRegisterTags.bind(this));b.post("/WriteTag",this.onWriteTag.bind(this))}async onWriteTag(b,a){var e=a.locals.session;b=b.body;const c=new Date,d=b.tagId;var f=g.TagHelper.getGenericHtmlIdOfHtmlId(d);const h=g.TagHelper.extractFieldIndexOfHtmlId(b.tagId);f=new g.Tag(f,[{fieldIndex:h,value:b.value,time:c,tagState:g.TagState.OK}]);await this.tagConnection.writeTags([f],e.sessionId);e=this.immediateWriteTagResponse?{E:g.TagState.OK,
T:g.Util.toFrontendDate(c),U:d,V:b.value}:null;a.send({d:e})}async onRegisterTags(b,a){this.logger.verbose("RegisterTags received");const e=a.locals.session;e.registeredTags=new Set(b.body.tagIds);try{const b=await this.tagConnection.readTags(e.sessionId);e.sendMessageToClient(this.createTagUpdateMessage(e,b));a.send({d:null})}catch(l){a.sendStatus(c.INTERNAL_SERVER_ERROR)}}onTagStoreUpdatedTags(b){for(const a of this.sessionHandling.sessions.values())a.sendMessageToClient(this.createTagUpdateMessage(a,
b))}createTagUpdateMessage(b,a){const e=[];for(const c of a)if(!c.sessionId||c.sessionId===b.sessionId)for(const d of c.values)a=g.TagHelper.htmlId(c.genericHTMLId,d.fieldIndex),b.registeredTags.has(a)&&e.push({Error:d.tagState,UniqueId:a,Value:d.value,TimeStamp:d.time.getTime()});return{options:{tagValues:e},type:"tagUpdate"}}}f.TagHandling=a});unwrapExports(TagHandling_1);
var TagHandling_2=TagHandling_1.TagHandling,UserManagementHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.UserManagementHandling=void 0;const g=require("@gti/globals"),d=require("@gti/service-base"),c=require("http-status-codes");class a{constructor(b,a){this.logger=b;this.userConnection=new d.UserFeathersConnection(this.logger,a);this.groupConnection=new d.GroupFeathersConnection(this.logger,a);this.userSessionConnection=new d.UserSessionFeathersConnection(this.logger,
a);this.userPasswordConnection=new d.UserPasswordFeathersConnection(this.logger,a);this.userDataConnection=new d.UserDataFeathersConnection(this.logger,a)}initHandlers(b){b.post("/UserLogin",this.onUserLogin.bind(this));b.post("/UserLogout",this.onUserLogout.bind(this));b.post("/ChangeUserPassword",this.onUserChangedPassword.bind(this));b.post("/GetUserList",this.onGetUserList.bind(this));b.post("/CreateOrModifyUser",this.onCreateOrUpdateUser.bind(this));b.post("/GetUserGroupList",this.onGetUserGroupList.bind(this));
b.post("/GetUserGroups",this.onGetUserGroups.bind(this));b.post("/DeleteUser",this.onDeleteUser.bind(this));b.post("/SaveUserData",this.onSaveUserData.bind(this));b.post("/GetUserData",this.onGetUserData.bind(this))}async onUserLogin(b,a){const e=a.locals.session;try{e.currentUserId&&(await this.userSessionConnection.removeUserSession(e.sessionId,e.currentUserId),e.currentUserId=void 0);const c=await this.userSessionConnection.createUserSession(e.sessionId,b.body);e.currentUserId=c.userSessionId;
a.send({d:JSON.stringify(c)})}catch(l){a.sendStatus(c.INTERNAL_SERVER_ERROR)}}async onUserLogout(b,a){b=a.locals.session;try{await this.userSessionConnection.removeUserSession(b.sessionId,b.currentUserId),b.currentUserId=void 0,a.send({d:null})}catch(k){a.sendStatus(c.INTERNAL_SERVER_ERROR)}}async onCreateOrUpdateUser(b,a){b=JSON.parse(b.body.userJson);b=g.User.createFromRuntimeUser(b);b=b.id?await this.userConnection.updateUser(b.id,b):await this.userConnection.createUser([b]);Array.isArray(b)&&
(b=b[0]);a.send({d:JSON.stringify({errorCode:0,userId:b.id})}).end()}async onDeleteUser(b,a){b=await this.userConnection.removeUser(b.body.id);a.send({d:b}).end()}async onUserChangedPassword(b,a){try{const c=await this.userPasswordConnection.changePassword(b.body);a.send({d:c})}catch(k){a.send({d:1})}}async onGetUserList(a,c){a=await this.userConnection.readUsers();c.send({d:JSON.stringify(a)})}async onGetUserGroupList(a,c){a=await this.groupConnection.readGroups();c.send({d:JSON.stringify(a)})}async onGetUserGroups(a,
e){e.sendStatus(c.NOT_IMPLEMENTED)}async onGetUserData(a,e){const b=e.locals.session;try{const c={key:a.body.key};a.body.respectUser&&(c.userSessionId=b.userSessionId);a.body.respectDevice&&(c.sessionId=b.sessionId);const d=await this.userDataConnection.readData(c);e.send({d})}catch(l){e.sendStatus(c.INTERNAL_SERVER_ERROR)}}async onSaveUserData(a,e){const b=e.locals.session;try{const c={key:a.body.key,value:a.body.value};a.body.respectUser&&(c.userSessionId=b.userSessionId);a.body.respectDevice&&
(c.sessionId=b.sessionId);await this.userDataConnection.createData(c);e.send({d:null})}catch(l){e.sendStatus(c.INTERNAL_SERVER_ERROR)}}}f.UserManagementHandling=a});unwrapExports(UserManagementHandling_1);
var UserManagementHandling_2=UserManagementHandling_1.UserManagementHandling,DataManagementHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.DataManagementHandling=void 0;const g=require("@gti/service-base");class d{constructor(c,a,b){this.logger=c;this.dataManagementConnClient=a;this.userSessionConnConnection=b;this.dataManagementConnection=new g.DataManagementConnection(c,this.dataManagementConnClient);this.userSessionConnConnection&&(this.userSessionConnection=
new g.UserSessionFeathersConnection(c,this.userSessionConnConnection))}initHandlers(c){c.post("/SendRecord",this.onSendRecord.bind(this));c.post("/ReceiveRecord",this.onReceiveRecord.bind(this));c.post("/DeleteRecord",this.onDeleteRecord.bind(this))}async onSendRecord(c,a){await this.dataManagementConnection.readFromDatabase({dataManagementId:c.body.type,name:c.body.name,user:null});a.send({d:null}).end()}async onReceiveRecord(c,a){const b=await this.getUser(a.locals.session);await this.dataManagementConnection.writeToDatabase({dataManagementId:c.body.type,
name:c.body.name,user:b});a.send({d:null}).end()}async onDeleteRecord(c,a){const b=await this.getUser(a.locals.session);await this.dataManagementConnection.deleteFromDatabase({dataManagementId:c.body.type,name:c.body.name,user:b});a.send({d:null}).end()}async getUser(c){return this.userSessionConnection&&c.currentUserId?(c=await this.userSessionConnection.readUserSession(c.currentUserId))?c.name:null:null}}f.DataManagementHandling=d});unwrapExports(DataManagementHandling_1);
var DataManagementHandling_2=DataManagementHandling_1.DataManagementHandling,GridExcelExporter_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.GridExcelExporter=void 0;const g=require("xlsx");class d{static export(c,a){const b=g.utils.book_new();b.SheetNames.push(d.SHEET_NAME);const e=[],k=a.map((a)=>a[0]);e.push(k);for(const b of c)c=a.map((a)=>{var c;return(null!==(c=b[a[1]])&&void 0!==c?c:"")+""}),e.push(c);a=g.utils.aoa_to_sheet(e);b.Sheets[d.SHEET_NAME]=
a;return g.write(b,{bookType:"xlsx",type:"buffer"})}}f.GridExcelExporter=d;d.SHEET_NAME="Grid"});unwrapExports(GridExcelExporter_1);
var GridExcelExporter_2=GridExcelExporter_1.GridExcelExporter,GridDataValueHelper_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.GridDataValueHelper=void 0;class g{static getDataValueFromColumnName(d,c){var a;return null!==(a=g.checkIfDataMetaColumn(d,c))&&void 0!==a?a:g.checkIfDataTagColumn(d,c)}static checkIfDataTagColumn(d,c){var a;return null===(a=c.tags.find((a)=>a.columnName===d))||void 0===a?void 0:a.value}static checkIfDataMetaColumn(d,c){const a=Object.keys(c).find((a)=>
a.toUpperCase()===d.toUpperCase());if(a)return"EditedOn"===d||"CreatedOn"===d?(new Date(c[a])).getTime():c[a]}}f.GridDataValueHelper=g});unwrapExports(GridDataValueHelper_1);
var GridDataValueHelper_2=GridDataValueHelper_1.GridDataValueHelper,GridHandling_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.GridHandling=void 0;const g=require("uuid"),d=require("http-status-codes"),c=require("@gti/service-base"),a=require("@gti/globals");class b{constructor(a,d,f,g){this.logger=a;this.dataManagementConnClient=d;this.notificationConnClient=f;this.sessionHandling=g;this.exportCache=new Map;this.dataFilterHandling=new GridFilter_1.GridFilter(a,
(a,b)=>GridDataValueHelper_1.GridDataValueHelper.getDataValueFromColumnName(a,b));this.notificationFilterHandling=new GridFilter_1.GridFilter(a,(a,c,e)=>GridNotificationValueHelper_1.GridNotificationValueHelper.getNotificationValueFromColumnName(a,c,GridNotificationValueHelper_1.DateConvertType.Timestamp,e.dataStore.get(b.LANGUAGE_KEY)));this.dataManagementConnClient&&(this.dataManagementConnection=new c.DataManagementConnection(a,this.dataManagementConnClient),this.dataManagementConnection.onManagementEntryUpdated((a)=>
this.onManagementEntryUpdated(1,a)),this.dataManagementConnection.onNewManagementEntry((a)=>this.onManagementEntryUpdated(0,a)),this.dataManagementConnection.onRemoveManagementEntry((a)=>this.onManagementEntryUpdated(2,a)));this.notificationConnClient&&(this.notificationConnection=new c.NotificationFeathersConnection(this.logger,this.notificationConnClient),this.notificationConnection.onNotificationUpdated(this.onNotificationUpdated.bind(this)))}initHandlers(a){a.post("/GetGridData",this.onGetGridData.bind(this));
a.post("/CloseDataSession",this.onCloseDataSession.bind(this));a.post("/ExportGridData",this.onExportGridData.bind(this));a.get("/DownloadCachedFile",this.onDownloadCachedFile.bind(this))}async onGetGridData(a,b){var c=b.locals.session;const e=a.body.query.Filter,d=a.body.language,f=a.body.query.RequestControlId,k=a.body.query.Columns;a=a.body.view;this.addGridSessionToDataStore(c,a,f,e,k);c=await this.getData(c,e,d,f,k,a,GridNotificationValueHelper_1.DateConvertType.Designer);b.send({d:{Columns:k,
Data:c,IsFiltered:!1,IsPaged:!1,IsSorted:!1,SupportsUpdateNotifications:!0,TotalCount:c.length}})}async onExportGridData(a,c){const e=c.locals.session;var d=a.body.info.Query.Filter;const f=a.body.info.Query.RequestControlId,k=a.body.info.Query.Columns,h=a.body.view;a=a.body.info.ExportColumns.map((a)=>[a.Caption,k.indexOf(a.DataField)]);d=await this.getData(e,d,"default",f,k,h,GridNotificationValueHelper_1.DateConvertType.ISO);d=GridExcelExporter_1.GridExcelExporter.export(d,a);const p=g.v4();this.exportCache.has(e.sessionId)||
this.exportCache.set(e.sessionId,new Map);this.exportCache.get(e.sessionId).set(p,d);setTimeout(()=>this.removeExportCacheEntry(e.sessionId,p),b.CACHE_RESET_TIME_MS);c.send({d:p})}onDownloadCachedFile(a,b){var c;const e=b.locals.session;a=a.query.fileId;const f=null===(c=this.exportCache.get(e.sessionId))||void 0===c?void 0:c.get(a);f?(this.removeExportCacheEntry(e.sessionId,a),b.setHeader("Content-Disposition","attachment; filename=Export.xlsx"),b.send(f)):b.sendStatus(d.BAD_REQUEST)}onCloseDataSession(a,
b){var c;null===(c=b.locals.session.dataStore.get(a.body.view))||void 0===c?void 0:c.delete(a.body.requestControlId);b.send({d:null})}onNotificationUpdated(a){for(const c of this.sessionHandling.sessions.values()){let e=[];c.dataStore.has(b.ALERT_LISTS_KEY)&&(e=Array.from(c.dataStore.get(b.ALERT_LISTS_KEY).values()));let d=[];c.dataStore.has(b.ALERT_PROTOCOLS_KEY)&&(d=Array.from(c.dataStore.get(b.ALERT_PROTOCOLS_KEY).values()));const f=c.dataStore.get(b.LANGUAGE_KEY);this.checkNotification(a,c,e,
!1,f);this.checkNotification(a,c,d,!0,f)}}onManagementEntryUpdated(a,b){for(const c of this.sessionHandling.sessions.values())Array.from(b.viewIds).filter((a)=>c.dataStore.has(a)).map((a)=>Array.from(c.dataStore.get(a).values())).filter((a)=>void 0!==a).map((e)=>this.checkDataManagement(e,a,c,b)).forEach((a)=>a.forEach((a)=>c.sendMessageToClient(a)))}removeExportCacheEntry(a,b){var c,e;(null===(c=this.exportCache.get(a))||void 0===c?0:c.has(b))&&this.exportCache.get(a).delete(b);0===(null===(e=this.exportCache.get(a))||
void 0===e?void 0:e.size)&&this.exportCache.delete(a)}async getData(a,b,c,d,f,g,h){switch(g){case "AlertList":if(!this.notificationConnection)break;d=await this.notificationConnection.getAllCurrentNotifications();return this.getAlarmingGridData(a,f,b,h,c,d);case "AlertProtocol":if(!this.notificationConnection)break;d=await this.notificationConnection.getAllNotifications();return this.getAlarmingGridData(a,f,b,h,c,d);default:if(this.dataManagementConnection)return c=await this.dataManagementConnection.getAllValues(g),
this.getDataGridData(a,f,b,c)}}checkNotification(b,c,d,f,g){const [e,k]=a.Util.partitionArray(d,(a)=>this.notificationFilterHandling.filter(b.notification,a.filter,c));e.map((a)=>this.createNotificationChangedMessage(a,b,f,a.id,g)).forEach((a)=>c.sendMessageToClient(a));k.map((c)=>this.createNotificationChangedMessage(c,Object.assign({},b,{type:a.NotificationUpdatedMessageType.Gone}),!1,c.id,g)).forEach((a)=>c.sendMessageToClient(a))}checkDataManagement(b,c,d,f){const [e,g]=a.Util.partitionArray(b,
(a)=>this.dataFilterHandling.filter(f,a.filter,d));b=e.map((a)=>this.crateDataChangedMessages(a,c,f));const k=g.map((a)=>this.crateDataChangedMessages(a,2,f));return a.Util.flattenArray([b,k])}createNotificationChangedMessage(a,b,c,d,f){c=this.getDataChangedType(b,c);a=this.notificationToFrontendData(a.columns,b.notification,GridNotificationValueHelper_1.DateConvertType.Designer,f);return{type:"dataChanged",options:{RequestControlId:d,Type:c,Data:a}}}crateDataChangedMessages(a,b,c){return{type:"dataChanged",
options:{RequestControlId:a.id,Type:b,Data:this.dataValueToFrontendData(a.columns,c)}}}getAlarmingGridData(a,b,c,d,f,g){return g.filter((b)=>this.notificationFilterHandling.filter(b,c,a)).map((a)=>this.notificationToFrontendData(b,a,d,f))}getDataGridData(a,b,c,d){return d.filter((b)=>this.dataFilterHandling.filter(b,c,a)).map((a)=>this.dataValueToFrontendData(b,a))}notificationToFrontendData(a,b,c,d){return a.map((a)=>GridNotificationValueHelper_1.GridNotificationValueHelper.getNotificationValueFromColumnName(a,
b,c,d))}dataValueToFrontendData(a,b){return a.map((a)=>GridDataValueHelper_1.GridDataValueHelper.getDataValueFromColumnName(a,b))}addGridSessionToDataStore(a,b,c,d,f){a.dataStore.has(b)||a.dataStore.set(b,new Map);a.dataStore.get(b).set(c,{id:c,filter:d,columns:f})}getDataChangedType(b,c){if(b.type===a.NotificationUpdatedMessageType.New)return 0;if(b.type===a.NotificationUpdatedMessageType.Update||b.type===a.NotificationUpdatedMessageType.Gone&&c)return 1;if(b.type===a.NotificationUpdatedMessageType.Gone&&
!c)return 2}}f.GridHandling=b;b.LANGUAGE_KEY="language";b.ALERT_LISTS_KEY="AlertList";b.ALERT_PROTOCOLS_KEY="AlertProtocol";b.CACHE_RESET_TIME_MS=1E3});unwrapExports(GridHandling_1);
var GridHandling_2=GridHandling_1.GridHandling,WebserverServiceInteraction_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.WebserverServiceInteraction=void 0;h=require("@gti/service-base");class g extends h.ServiceInteractionBase{constructor(d,c,a,b){super(d,c,a,b);this.serviceConfigurationSchema={properties:{http:{properties:{enable:{type:"boolean"},port:{maximum:65535,minimum:0,type:"number"}},required:["port","enable"]},https:{properties:{certificateFile:{type:"string"},
enable:{type:"boolean"},keyFile:{type:"string"},port:{maximum:65535,minimum:0,type:"number"}},required:["port"]}},immediateWriteTagResponse:{type:"boolean"},connectionTimeout:{type:"number"},required:["http"],type:"object"};this.serviceConfiguration={http:{enable:!0,port:16700},https:{enable:!1,port:17700,certificateFile:"cert.pem",keyFile:"key.pem"},immediateWriteTagResponse:g.IMMEDIATE_WRITE_TAGS_RESPONSE_DEFAULT,connectionTimeout:g.CONNECTION_TIMEOUT_DEFAULT}}async closeClientSession(d){(d=this.webserver.sessionHandling.sessions.get(d))&&
await this.webserver.sessionHandling.closeSession(d)}async getAllSessionInformation(){return this.webserver?this.webserver.currentSessions.map((d)=>({userSessionId:d.currentUserId,sessionId:d.sessionId,hostname:d.hostname,ip:d.ip})):[]}async onConfigureService(d){await super.onConfigureService(d);await this.createNewWebserver(d);d=await this.basicFnc.getLicense();await this.webserver.start(void 0,void 0,d)}async onRun(){await super.onRun();this.webserver.running&&await this.webserver.stop();const d=
await this.basicFnc.getLicense();this.projectConfiguration&&this.projectConfiguration.runningProjectDirectory&&await this.webserver.start(this.projectConfiguration.runningProjectDirectory,this.projectConfiguration.runningProjectExportId,d)}async onPause(){this.webserver.running&&await super.onPause();void 0!==this.webserver&&this.webserver.running&&await this.webserver.stop()}async onConfigureProject(d){await super.onConfigureProject(d)}async createNewWebserver(d){var c,a;void 0!==this.webserver&&
await this.webserver.stop();var b=(a)=>this.connectionServiceClientSupplier.getConnectionServiceClient(a),e=null!==(c=d.connectionTimeout)&&void 0!==c?c:g.CONNECTION_TIMEOUT_DEFAULT;c=new SessionHandling_1.SessionHandling(this.logger,b("tag-store"),e);e=null!==(a=d.immediateWriteTagResponse)&&void 0!==a?a:g.IMMEDIATE_WRITE_TAGS_RESPONSE_DEFAULT;a=new TagHandling_1.TagHandling(this.logger,b("tag-store"),c,e);d=new WebserverBuilder_1.WebserverBuilder(this.logger,d,c,a);this.systemConfig.services.some((a)=>
"user-management"===a)&&(a=new UserManagementHandling_1.UserManagementHandling(this.logger,b("user-management")),d.withUserManagement(a));this.systemConfig.services.some((a)=>"data-logger"===a)&&(a=b("data-logger"),e=b("tag-store"),a=new DataLoggerHandling_1.DataLoggerHandling(this.logger,a,e),d.withDataLogger(a));this.systemConfig.services.some((a)=>"data-management"===a)&&(a=b("user-management"),e=b("data-management"),a=new DataManagementHandling_1.DataManagementHandling(this.logger,e,a),d.withDataManagement(a));
this.systemConfig.services.some((a)=>"scripter"===a)&&(a=b("scripter"),e=new ScriptingHandling_1.ScriptingHandling(this.logger,a,c),d.withScripting(e),c.setScriptConnectionClient(a));this.systemConfig.services.some((a)=>"alert-notifier"===a)&&(a=new NotificationHandling_1.NotificationHandling(this.logger,b("alert-notifier"),c),d.withNotification(a));this.systemConfig.services.some((a)=>"alert-notifier"===a||"data-management"===a)&&(a=b("alert-notifier"),b=b("data-management"),b=new GridHandling_1.GridHandling(this.logger,
b,a,c),d.withGrid(b));this.webserver=d.build()}}f.WebserverServiceInteraction=g;g.IMMEDIATE_WRITE_TAGS_RESPONSE_DEFAULT=!0;g.CONNECTION_TIMEOUT_DEFAULT=12E4});unwrapExports(WebserverServiceInteraction_1);
var WebserverServiceInteraction_2=WebserverServiceInteraction_1.WebserverServiceInteraction,Application_1=createCommonjsModule(function(h,f){Object.defineProperty(f,"__esModule",{value:!0});f.Application=void 0;const g=require("@gti/service-base");class d extends g.ApplicationBase{constructor(c,a){const b=new g.ServiceConnectionBase;a=new WebserverServiceInteraction_1.WebserverServiceInteraction("connector-webserver",c,a,b);super("connector-webserver",c,b,a);this.sessionService=new g.SessionService(a)}async initApplication(){this.services.push(this.sessionService);
return super.initApplication()}}f.Application=d});unwrapExports(Application_1);
var Application_2=Application_1.Application,src=createCommonjsModule(function(h,f){var g=commonjsGlobal&&commonjsGlobal.__createBinding||(Object.create?function(d,c,a,b){void 0===b&&(b=a);Object.defineProperty(d,b,{enumerable:!0,get:function(){return c[a]}})}:function(d,c,a,b){void 0===b&&(b=a);d[b]=c[a]});h=commonjsGlobal&&commonjsGlobal.__exportStar||function(d,c){for(var a in d)"default"===a||c.hasOwnProperty(a)||g(c,d,a)};Object.defineProperty(f,"__esModule",{value:!0});h(Application_1,f)}),index=
unwrapExports(src);module.exports=index;
