import { Params } from '@feathersjs/feathers';
interface ServiceOptions {
    name: string;
    connection: any;
    method: string;
    events?: string[];
    timeout?: number;
}
export declare class Service {
    events: string[];
    path: string;
    connection: any;
    method: string;
    timeout: number;
    constructor(options: ServiceOptions);
    send(method: string, ...args: any[]): Promise<unknown>;
    find(params?: Params): Promise<unknown>;
    get(id: number | string, params?: Params): Promise<unknown>;
    create(data: any, params?: Params): Promise<unknown>;
    update(id: number | string, data: any, params?: Params): Promise<unknown>;
    patch(id: number | string, data: any, params?: Params): Promise<unknown>;
    remove(id: number | string, params?: Params): Promise<unknown>;
    off(name: string, ...args: any[]): any;
}
export {};
