#!/bin/sh

SCRIPTPATH="$( cd "$(dirname "$0")" ; pwd -P )"

echo "Start procon-web-embedded-systems service installer..."
ldFile=$(ls $SCRIPTPATH/../lib/ld*)

echo "[Unit]
Description=PROCON-WEB Embedded Systems
Documentation=https://www.gti.de/produkte-der-gti/procon-web/
After=network.target systemd-modules-load.service

[Service]
WorkingDirectory=$SCRIPTPATH
Environment=\"HOME=$SCRIPTPATH\"
ExecStart=$ldFile --library-path $SCRIPTPATH/../lib $SCRIPTPATH/wm-iot

StandardOutput=journal
StandardError=journal

[Install]
WantedBy=multi-user.target" > procon-web-es.service

mv ./procon-web-es.service /lib/systemd/system/
systemctl enable procon-web-es.service
systemctl start procon-web-es.service
# systemctl status procon-web-es.service
